/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CropComponentIngredient
extends Ingredient {
    private final Crop crop;
    private final ComponentType type;

    public CropComponentIngredient(Crop crop, ComponentType type) {
        super(Stream.empty());
        this.crop = crop;
        this.type = type;
    }

    public CropComponentIngredient(Crop crop, ComponentType type, Stream<Ingredient.Value> itemList) {
        super(itemList);
        this.crop = crop;
        this.type = type;
    }

    public boolean test(ItemStack input) {
        if (input == null) {
            return false;
        }
        if (!super.test(input)) {
            return false;
        }
        return Arrays.stream(this.m_43908_()).anyMatch(s -> s.m_41773_() == input.m_41773_() && (!s.m_41782_() || s.areShareTagsEqual(input)));
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "mysticalagriculture:crop_component");
        json.addProperty("component", this.type.name);
        json.addProperty("crop", this.crop.getId().toString());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.CROP_COMPONENT_INGREDIENT;
    }

    public static enum ComponentType {
        ESSENCE("essence"),
        SEED("seed"),
        MATERIAL("material");

        private static final Map<String, ComponentType> LOOKUP;
        public final String name;

        private ComponentType(String name) {
            this.name = name;
        }

        public static ComponentType fromName(String name) {
            return LOOKUP.get(name);
        }

        static {
            LOOKUP = new HashMap<String, ComponentType>();
            for (ComponentType value : ComponentType.values()) {
                LOOKUP.put(value.name, value);
            }
        }
    }

    public static class Serializer
    implements IIngredientSerializer<CropComponentIngredient> {
        public CropComponentIngredient parse(FriendlyByteBuf buffer) {
            Crop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(buffer.m_130277_()));
            ComponentType type = ComponentType.fromName(buffer.m_130277_());
            Stream<Ingredient.Value> itemList = Stream.generate(() -> ((FriendlyByteBuf)buffer).m_130267_()).limit(buffer.m_130242_()).map(Ingredient.ItemValue::new);
            return new CropComponentIngredient(crop, type, itemList);
        }

        public CropComponentIngredient parse(JsonObject json) {
            Ingredient.ItemValue itemList;
            String cropId = GsonHelper.m_13906_((JsonObject)json, (String)"crop");
            String typeName = GsonHelper.m_13906_((JsonObject)json, (String)"component");
            Crop crop = CropRegistry.getInstance().getCropById(new ResourceLocation(cropId));
            ComponentType type = ComponentType.fromName(typeName);
            switch (type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ESSENCE: {
                    Ingredient.ItemValue itemValue = new Ingredient.ItemValue(new ItemStack((ItemLike)crop.getTier().getEssence()));
                    break;
                }
                case SEED: {
                    Ingredient.ItemValue itemValue = new Ingredient.ItemValue(new ItemStack((ItemLike)crop.getType().getCraftingSeed()));
                    break;
                }
                case MATERIAL: {
                    Ingredient.ItemValue itemValue = itemList = crop.getLazyIngredient().createValue();
                }
            }
            if (itemList == null) {
                return new CropComponentIngredient(crop, type);
            }
            return new CropComponentIngredient(crop, type, Stream.of(itemList));
        }

        public void write(FriendlyByteBuf buffer, CropComponentIngredient ingredient) {
            buffer.m_130070_(ingredient.crop.getId().toString());
            buffer.m_130070_(ingredient.type.name);
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack item : items) {
                buffer.m_130055_(item);
            }
        }
    }
}

